/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.autoplot.PlotStylePanel;
import org.autoplot.dom.PlotElement;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.graph.DasColorBar;
import org.das2.graph.Renderer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class PitchAngleDistributionStylePanel
extends JPanel
implements PlotStylePanel.StylePanel {
    BindingGroup elementBindingContext;
    Renderer renderer;
    EnumerationEditor edit;
    private JCheckBox clockwiseCB;
    private JPanel colortableTypePanel;
    private JCheckBox drawPolarAxesCB;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JCheckBox mirrorCB;
    private JComboBox originDL;
    private String control;
    public static final String PROP_CONTROL = "control";

    public PitchAngleDistributionStylePanel() {
        this.initComponents();
        this.edit = new EnumerationEditor();
        this.edit.setValue((Object)DasColorBar.Type.GRAYSCALE);
        this.colortableTypePanel.add(this.edit.getCustomEditor(), "Center");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.mirrorCB = new JCheckBox();
        this.originDL = new JComboBox();
        this.jLabel1 = new JLabel();
        this.drawPolarAxesCB = new JCheckBox();
        this.clockwiseCB = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.colortableTypePanel = new JPanel();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Pitch Angle Distribution"));
        this.mirrorCB.setText("Mirror");
        this.mirrorCB.setToolTipText("Mirror 0-180 deg to cover all angles");
        this.mirrorCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PitchAngleDistributionStylePanel.this.mirrorCBActionPerformed(evt);
            }
        });
        this.originDL.setModel(new DefaultComboBoxModel<String>(new String[]{"East", "South", "West", "North"}));
        this.originDL.setToolTipText("Direction of 0 degrees");
        this.originDL.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PitchAngleDistributionStylePanel.this.originDLItemStateChanged(evt);
            }
        });
        this.jLabel1.setText("Angle Zero:");
        this.jLabel1.setToolTipText("The direction from the center of the origin of the angle.");
        this.drawPolarAxesCB.setText("Draw Polar Axes");
        this.drawPolarAxesCB.setToolTipText("Draw additional axes at 0,30,60,... degrees.");
        this.drawPolarAxesCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PitchAngleDistributionStylePanel.this.drawPolarAxesCBActionPerformed(evt);
            }
        });
        this.clockwiseCB.setText("Clockwise");
        this.clockwiseCB.setToolTipText("Angles increase in clockwise direction");
        this.clockwiseCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PitchAngleDistributionStylePanel.this.clockwiseCBActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Colortable:");
        this.jLabel4.setToolTipText("Color table for spectrograms");
        this.colortableTypePanel.setLayout(new BorderLayout());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colortableTypePanel, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mirrorCB).addComponent(this.drawPolarAxesCB).addComponent(this.clockwiseCB).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.originDL, -2, 110, -2))).addGap(0, 107, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 27, -2).addComponent(this.colortableTypePanel, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mirrorCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.originDL, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.drawPolarAxesCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clockwiseCB).addContainerGap(126, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
    }

    private void mirrorCBActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void originDLItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.update();
        }
    }

    private void drawPolarAxesCBActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void clockwiseCBActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void update() {
        String c;
        String oldValue = this.control;
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("mirror", Renderer.encodeBooleanControl((boolean)this.mirrorCB.isSelected()));
        controls.put("drawPolarAxes", Renderer.encodeBooleanControl((boolean)this.drawPolarAxesCB.isSelected()));
        controls.put("origin", this.originDL.getSelectedItem().toString().substring(0, 1).toUpperCase());
        controls.put("clockwise", Renderer.encodeBooleanControl((boolean)this.clockwiseCB.isSelected()));
        this.control = c = Renderer.formatControl(controls);
        this.firePropertyChange(PROP_CONTROL, oldValue, c);
    }

    private void updateGUI(Renderer renderer) {
        if (renderer == null) {
            return;
        }
        this.control = renderer.getControl();
        this.mirrorCB.setSelected(renderer.getBooleanControl("mirror", false));
        this.drawPolarAxesCB.setSelected(renderer.getBooleanControl("drawPolarAxes", false));
        String s = renderer.getControl("origin", "E");
        if (s.equals("E")) {
            this.originDL.setSelectedItem("East");
        } else if (s.equals("S")) {
            this.originDL.setSelectedItem("South");
        } else if (s.equals("W")) {
            this.originDL.setSelectedItem("West");
        } else if (s.equals("N")) {
            this.originDL.setSelectedItem("North");
        }
        this.clockwiseCB.setSelected(renderer.getBooleanControl("clockwise", false));
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        this.updateGUI(this.renderer);
        this.firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    @Override
    public void doElementBindings(PlotElement element) {
        this.renderer = element.getController().getRenderer();
        this.updateGUI(this.renderer);
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)element, (Property)BeanProperty.create((String)"renderControl"), (Object)this, (Property)BeanProperty.create((String)PROP_CONTROL)));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)element.getStyle(), (Property)BeanProperty.create((String)"colortable"), (Object)this.edit, (Property)BeanProperty.create((String)"value")));
        if (this.elementBindingContext != null) {
            this.releaseElementBindings();
        }
        bc.bind();
        this.repaint();
        this.elementBindingContext = bc;
    }

    @Override
    public void releaseElementBindings() {
        if (this.elementBindingContext != null) {
            this.elementBindingContext.unbind();
            this.elementBindingContext = null;
        }
    }
}

